<?php
/*
Plugin Name: Secure Content Viewer By Mohammad Norouzi
Description: Display protected images and videos based on user-entered codes. Includes admin interface to manage content.
Version: 1.0
Author: Mohammad Norouzi
Plugin URI:  https://ramanet.ir
Author URI:  https://ramanet.ir
*/

// Register custom post type for codes
function scv_register_custom_post_type() {
    register_post_type('scv_code',
        array(
            'labels' => array(
                'name' => __('Secure Codes'),
                'singular_name' => __('Secure Code'),
                'add_new' => __('Add New Code'),
                'add_new_item' => __('Add New Secure Code'),
                'edit_item' => __('Edit Secure Code'),
                'new_item' => __('New Secure Code'),
                'view_item' => __('View Secure Code'),
                'search_items' => __('Search Secure Codes'),
            ),
            'public' => false,
            'show_ui' => true,
            'has_archive' => false,
            'menu_icon' => 'dashicons-lock',
            'supports' => array('title'),
        )
    );
}
add_action('init', 'scv_register_custom_post_type');

// Add meta boxes
function scv_add_meta_boxes() {
    add_meta_box('scv_meta_box', 'Secure Content', 'scv_render_meta_box', 'scv_code', 'normal', 'high');
}
add_action('add_meta_boxes', 'scv_add_meta_boxes');

function scv_render_meta_box($post) {
    $image = get_post_meta($post->ID, '_scv_image', true);
    $video = get_post_meta($post->ID, '_scv_video', true);
    wp_nonce_field('scv_save_meta_box_data', 'scv_meta_box_nonce');
    ?>
    <p>
        <label for="scv_image">Image URL:</label><br>
        <input type="text" name="scv_image" id="scv_image" value="<?php echo esc_attr($image); ?>" style="width:100%;">
    </p>
    <p>
        <label for="scv_video">Video URL:</label><br>
        <input type="text" name="scv_video" id="scv_video" value="<?php echo esc_attr($video); ?>" style="width:100%;">
    </p>
    <?php
}

// Save meta box data
function scv_save_meta_box_data($post_id) {
    if (!isset($_POST['scv_meta_box_nonce']) ||
        !wp_verify_nonce($_POST['scv_meta_box_nonce'], 'scv_save_meta_box_data')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (isset($_POST['scv_image'])) {
        update_post_meta($post_id, '_scv_image', sanitize_text_field($_POST['scv_image']));
    }
    if (isset($_POST['scv_video'])) {
        update_post_meta($post_id, '_scv_video', sanitize_text_field($_POST['scv_video']));
    }
}
add_action('save_post', 'scv_save_meta_box_data');

// Modify shortcode to pull from DB
function scv_shortcode() {
    ob_start();
    ?>
    <div id="secure-content-container" class="scv-container">
        <h2>Enter Access Code</h2>
        <input type="text" id="access-code" placeholder="Enter your code">
        <button onclick="checkCode()">Submit</button>
        <div id="content-area" class="scv-hidden">
            <h3>Your Content</h3>
            <img id="content-image" src="" alt="Content Image">
            <video id="content-video" controls autoplay="false" oncontextmenu="return false" controlsList="nodownload">
                <source src="" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
        <div id="error-message" class="scv-error scv-hidden">Invalid code. Please try again.</div>
    </div>
    <script>
        const contentMap = {};
        <?php
        $codes = get_posts(array('post_type' => 'scv_code', 'posts_per_page' => -1));
        foreach ($codes as $code) {
            $image = esc_js(get_post_meta($code->ID, '_scv_image', true));
            $video = esc_js(get_post_meta($code->ID, '_scv_video', true));
            echo "contentMap['" . esc_js($code->post_title) . "'] = { image: '$image', video: '$video' };
";
        }
        ?>
    </script>
    <script src="<?php echo plugin_dir_url(__FILE__); ?>script.js"></script>
    <?php
    return ob_get_clean();
}
add_shortcode('secure_content_viewer', 'scv_shortcode');

// Enqueue styles
function scv_enqueue_styles() {
    wp_enqueue_style('scv-style', plugin_dir_url(__FILE__) . 'style.css');
}
add_action('wp_enqueue_scripts', 'scv_enqueue_styles');
?>
