<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Lorem Ipsum Generator
 * Displays ipsum dummy text.
 */


if ( !class_exists( 'avia_lipsum' ) )
{
	class avia_sc_lipsum extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('Lorem Ipsum', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."lorem.png";
			$this->config['order']		= 20;
			$this->config['target']		= 'avia-target-insert';
			$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
			$this->config['shortcode'] 	= 'avia_lipsum';
			$this->config['tooltip'] 	= __('Displays Advanced Custom Field values.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
			$this->config['preview'] 	= "large";
		}
		
		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					array(
							"name" 	=> "",
							"desc" 	=> __("This element utilizes a remote API to randomly generate Lorem Ipsum text based on the parameters set below. The text will randomize each time the page is refreshed.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
					array(	
						"name" 	=> __("Paragraphs", 'avia_framework' ),
						"desc" 	=> __("The number of paragraphs to generate.", 'avia_framework' ),
						"id" 	=> "parag",
						"std" 	=> __("1", 'avia_framework' ),
						"type" 	=> "input"),
					array(	
						"name" 	=> __("Paragraph Length", 'avia_framework' ),
						"desc" 	=> __("The average length of a paragraph.", 'avia_framework' ),
						"id" 	=> "para_length",
						"type" 	=> "select",
						"std" 	=> "short",
						"subtype" => array( __("Short", 'avia_framework' )=>'short', __("Medium", 'avia_framework' )=>'medium', __("Large", 'avia_framework' )=>'large', __("Very Large", 'avia_framework' )=>'verylarge')
							),
					array(	
						"name" 	=> __("Decorate", 'avia_framework' ),
						"desc" 	=> __("Add bold, italic and marked text.", 'avia_framework' ),
						"id" 	=> "decorate",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Links", 'avia_framework' ),
						"desc" 	=> __("Add links.", 'avia_framework' ),
						"id" 	=> "link",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Unordered Lists", 'avia_framework' ),
						"desc" 	=> __("Add unordered lists.", 'avia_framework' ),
						"id" 	=> "ul",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Ordered Lists", 'avia_framework' ),
						"desc" 	=> __("Add ordered lists.", 'avia_framework' ),
						"id" 	=> "ol",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Description Lists", 'avia_framework' ),
						"desc" 	=> __("Add description lists.", 'avia_framework' ),
						"id" 	=> "dl",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Blockquotes", 'avia_framework' ),
						"desc" 	=> __("Add blockquotes.", 'avia_framework' ),
						"id" 	=> "bq",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Code Samples", 'avia_framework' ),
						"desc" 	=> __("Add random code samples.", 'avia_framework' ),
						"id" 	=> "code",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Headers", 'avia_framework' ),
						"desc" 	=> __("Add headers.", 'avia_framework' ),
						"id" 	=> "header",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("CAPS LOCK", 'avia_framework' ),
						"desc" 	=> __("Use all CAPS.", 'avia_framework' ),
						"id" 	=> "allcaps",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(	
						"name" 	=> __("Plain Text", 'avia_framework' ),
						"desc" 	=> __("Use all plain text, no html.", 'avia_framework' ),
						"id" 	=> "plaintext",
						"type" 	=> "select",
						"std" 	=> "no",
						"subtype" => array( __("Yes", 'avia_framework' )=>'yes', __("No", 'avia_framework' )=>'no')
							),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('parag'=>'', 'para_length'=>'', 'decorate'=>'', 'link'=>'', 'ul'=>'', 'ol'=>'', 'dl'=>'', 'bq'=>'', 'code'=>'', 'header'=>'', 'allcaps'=>'', 'plaintext'=>''), $atts, $this->config['shortcode']));
			
			
			$parag = '/'.$atts['parag'];
			$para_length  = '/'.$atts['para_length'];
			$decorate = $atts['decorate'];
				if($decorate == 'no') $decorate = '';
				if($decorate == 'yes') $decorate = '/decorate';
			$link = $atts['link'];
				if($link == 'no') $link = '';
				if($link == 'yes') $link = '/link';
			$ul = $atts['ul'];
				if($ul == 'no') $ul = '';
				if($ul == 'yes') $ul = '/ul';
			$ol = $atts['ol'];
				if($ol == 'no') $ol = '';
				if($ol == 'yes') $ol = '/ol';
			$dl = $atts['dl'];
				if($dl == 'no') $dl = '';
				if($dl == 'yes') $dl = '/dl';
			$bq = $atts['bq'];
				if($bq == 'no') $bq = '';
				if($bq == 'yes') $bq = '/bq';
			$code = $atts['code'];
				if($code == 'no') $code = '';
				if($code == 'yes') $code = '/code';
			$header = $atts['header'];
				if($header == 'no') $header = '';
				if($header == 'yes') $header = '/headers';
			$allcaps = $atts['allcaps'];
				if($allcaps == 'no') $allcaps = '';
				if($allcaps == 'yes') $allcaps = '/allcaps';
			$plaintext = $atts['plaintext'];
				if($plaintext == 'no') $plaintext = '';
				if($plaintext == 'yes') $plaintext = '/plaintext';
			
			$callout = 'http://loripsum.net/api'.$parag.$para_length.$decorate.$link.$ul.$ol.$dl.$bq.$code.$header.$allcaps.$plaintext;
			$content = file_get_contents($callout);
			$meta['el_class'];
						
			return $content;
		}
	}
}
